--[[
%% properties
14 value
18 value
%% globals
--]]

-- IDs der Rauchmelder (Oben in den properties die IDs auch eintragen)
local smokeID = {14,18} -- 327 Türkontakt

-- Einstellungen für die Sirene(n) (Wenn keine IDs eingetragen sind, wird die Funktion nicht genutzt)
local sireneID = {137,196} -- ID der Sirene(n) (137,196)

-- Einstellungen für Push-Benachrichtigungen (Wenn keine IDs eingetragen sind, wird die Funktion nicht genutzt)
local phoneID = {62,232} -- ID der Handys

-- Einstellungen für Notfallbeleuchtung (Wenn keine IDs eingetragen sind, wird die Funktion nicht genutzt)
local lightID = {240} -- ID der Licht-Module

-- Einstellungen für RGBW-Notfallbeleuchtung (Wenn keine IDs eingetragen sind, wird die Funktion nicht genutzt)
local rgbwID = {91} -- ID RGBW
local mode = 'color' -- Auswahl: color = Farbwert setzen; programm = Programm starten
local programm = 5 
local color = '255,255,255,255' -- welche Farbe eingestellt werden soll 

-- Einstellungen für Fluchtweg (Rollershutter/Danalock) (Wenn keine IDs eingetragen sind, wird die Funktion nicht genutzt)
local rollershutterID = {} -- ID der Rollershutter-Module
local danalockID = {} -- ID Danalock

local countID = 500

-- AB HIER NICHTS MEHR ÄNDERN

-- Funktion zum Versenden der Push
function sendPush(text)
 if (phoneID[1] ~= nil) then
  for k=1, countID do
     if phoneID[k] ~= nil then
       fibaro:call(phoneID[k],'sendPush', text, 'smoke')
     end
  end
 end
end

-- Funktion zum Ein-/Ausschalten der Sirene
function onoffSirene(status)
 if (sireneID[1] ~= nil) then 
  if (status == 'true') then
   fibaro:debug('Sirenen einschalten')
   for a=1, countID do
     if sireneID[a] ~= nil then
       fibaro:call(sireneID[a],'turnOn')
     end
   end
  else
   if (sireneID[1] ~= nil) then  
    fibaro:debug('Sirenen ausschalten')
    for a=1, countID do
      if sireneID[a] ~= nil then
        fibaro:call(sireneID[a],'turnOff')
      end
    end
   end
  end
 end
end

-- Funktion zum Ein-/Ausschalten der Notfallbeleuchtung
function emergencyLight(status)
 if (lightID[1] ~= nil) then 
  if (status == 'true') then
   fibaro:debug('Notfallbeleuchtung einschalten')
   for l=1, countID do
     if lightID[l] ~= nil then
       fibaro:call(lightID[l],'turnOn')
     end
   end
  else
   if (lightID[1] ~= nil) then 
    fibaro:debug('Notfallbeleuchtung ausschalten')
    for l=1, countID do
      if lightID[l] ~= nil then
        fibaro:call(lightID[l],'turnOff')
      end
    end 
   end
  end
 end
end

-- Funktion zum Ein-/Ausschalten der RGBW-Notfallbeleuchtung
function emergencyRGBW(status)
 if (rgbwID[1] ~= nil) then 
  if (status == 'true') then
   if (mode == 'color') then 
    fibaro:debug('RGBW-Notfallbeleuchtung einschalten - Setze Farbe')
    local RGBWTable = {}
    local i = 1
    for value in string.gmatch(color,"(%d+)") do
     RGBWTable[i] = value
     i = i + 1
    end
    for o=1, countID do
      if rgbwID[o] ~= nil then
        fibaro:call(rgbwID[o], "setColor", RGBWTable[1], RGBWTable[2], RGBWTable[3], RGBWTable[4])
      end
    end
   elseif (mode == 'programm') then
    fibaro:debug('RGBW-Notfallbeleuchtung einschalten - Starte Programm')
    for o=1, countID do
     if rgbwID[o] ~= nil then
       fibaro:call(rgbwID[o], 'startProgram', programm)
     end
    end
   end 
  else
   if (rgbwID[1] ~= nil) then 
    fibaro:debug('RGBW-Notfallbeleuchtung ausschalten')
    for o=1, countID do
      if rgbwID[o] ~= nil then
        fibaro:call(rgbwID[o], "setColor", 255,0,0,0)
      end
    end 
   end
  end
 end
end

-- Funktion für die Öffnung der Fluchtroute
function openEscapeRoute()
  if (rollershutterID[1] ~= nil) then
    fibaro:debug('Rollläden werden geöffnet.')
    for r=1, countID do
     if rollershutterID[r] ~= nil then
       fibaro:call(rollershutterID[r],'open')
     end
    end
  if (danalockID[1] ~= nil) then
    fibaro:debug('Türschlösser werden geöffnet.')
    for d=1, countID do
     if danalockID[d] ~= nil then
       fibaro:call(danalockID[d],'unsecure')
     end
    end
  end
 end
end

-- Funktion zum Anlegen einer Globalen Variablen
function globalVar(var,val)
  local http = net.HTTPClient()
  http:request("http://127.0.0.1:11111/api/globalVariables", {
    options = {
    method = 'POST',
    headers = {},
    data = '{"name":"'..var..'","value":"'..val..'"}',
    timeout = 10000
  },
  success = function(response)
            local result = response.data;
            if response.status == 200 or response.status == 201 then
              fibaro:debug('Status: ' ..response.status.. ' - Variable wurde angelegt')
            else
              fibaro:debug('Error: ' ..response.status.. ' - Zugriff verweigert')
            end
            end,
  error = function(err)
          fibaro:debug('[ERROR] ' .. err)
          end
  })
end

-- Funktion zum Prüfen des Rauch-Status
function checkSmoke()
 fibaro:debug('1 Rauchmelder meldet sicher. Prüfe die anderen Sensoren.')
 local smoke_counter = 0 
 for s=1, countID do
    if smokeID[s] ~= nil then
      if tonumber(fibaro:getValue(smokeID[s], "value")) == 1 then
        smoke_counter = smoke_counter+1
      end
    end
 end
 if (smoke_counter == 0) then
   fibaro:debug('Alle Rauchmelder sind sicher.')
   return true
 elseif (smoke_counter > 0) then
   fibaro:debug(smoke_counter..' Rauchmelder noch nicht sicher...')
   return false
 end
end

fibaro:debug('Rauchmelder-Szene v1.1RC gestartet.')

local var = 'smoke_alarm'

local trigger = fibaro:getSourceTrigger()

if (trigger['type']=='property') then
  local smokeID = tonumber(trigger['deviceID'])
  local smoke = tonumber(fibaro:getValue(smokeID, "value"))
  local room = fibaro:getRoomNameByDeviceID(smokeID)
  if (fibaro:getGlobal(var) ~= nil) then
    fibaro:debug('Benötigte Variable ' ..var.. ' erkannt.')
  else
    fibaro:debug('Benötigte Variable ' ..var.. ' NICHT erkannt. Wird erstellt.')
    globalVar(var, 'false')
  end
  if (smoke == 1 and fibaro:getGlobal(var) == 'false') then
  	fibaro:debug('Rauch im Raum: ' .. room .. ' erkannt.')
    fibaro:setGlobal(var, 'true')
    onoffSirene(fibaro:getGlobal(var))
    emergencyLight(fibaro:getGlobal(var))
    openEscapeRoute()
    emergencyRGBW(fibaro:getGlobal(var))
    sendPush('ACHTUNG! Rauch im Raum: ' .. room .. ' erkannt!')
  elseif (smoke == 0 and fibaro:getGlobal(var) == 'true') then
    if checkSmoke() then
      fibaro:debug('Schalte Rauch-Alarm aus')
      fibaro:setGlobal(var, 'false')
      onoffSirene(fibaro:getGlobal(var))
      emergencyLight(fibaro:getGlobal(var))
      emergencyRGBW(fibaro:getGlobal(var))
      sendPush('Alle Rauchmelder melden den Status sicher!')
    end
  elseif (smoke == 1 and fibaro:getGlobal(var) == 'true') then
    fibaro:debug('Ein weiterer Rauchmelder im Raum '..room..' hat Rauch erkannt. Alarm bereits ausgelöst.')
    sendPush('Weiterer Rauchmelder - '..room..' - ausgelöst!')
  elseif (fibaro:getGlobal(var) == 'NaN') then
    fibaro:debug('ACHTUNG: Wert der Variablen stimmt nicht. Skript einmal manuell ausführen')
  else
    fibaro:debug('Szene wurde durch Rauchmelder getriggert. Es wurde kein Rauch erkannt.')
  end
else
  fibaro:debug('Szene wurde manuell ausgelöst.')
  if (fibaro:getGlobal(var) ~= nil) then
    fibaro:debug('Benötigte Variable ' ..var.. ' erkannt.')
     if (fibaro:getGlobal(var) == 'NaN') then
       fibaro:debug('Inhalt: ' ..fibaro:getGlobal(var).. ' erkannt. Wird korrigiert.')
       fibaro:setGlobal(var, 'false')
     else
       fibaro:debug('Inhalt: ' ..fibaro:getGlobal(var).. ' erkannt. Ist korrekt.')
     end
     fibaro:debug('Versende eine Test-Push-Nachricht')
     sendPush('Push-Nachricht funktioniert. IDs der Handys korrekt.')
  else
    fibaro:debug('Benötigte Variable ' ..var.. ' NICHT erkannt. Wird erstellt.')
    globalVar(var, 'false')
    sendPush('Push-Nachricht funktioniert. IDs der Handys korrekt.')
    fibaro:debug('Versende eine Test-Push-Nachricht')
  end
end