--[[
%% properties
14 value
%% globals
--]]

-- IDs of the smokesensors (put it in the header also)
local smokeID = {14,18,35,160,211}

-- Settings for the siren(s) (If no IDs are registered, the function is not used)
local sireneID = {137,196} -- ID of siren

-- Settings for Push-Messages (If no IDs are registered, the function is not used)
local phoneID = {62,232} -- ID of mobile devices

-- Settings for emergency-lights (If no IDs are registered, the function is not used)
local lightID = {240} -- ID of lights

-- Settings for RGBW-emergency-lights (If no IDs are registered, the function is not used)
local rgbwID = {91} -- ID RGBW
local mode = 'color' -- Selection: color = set color value; programm = start program
local programm = 5 
local color = '255,255,255,255' -- the color to be adjusted

-- Settings for escape route (If no IDs are registered, the function is not used)
local rollershutterID = {} -- ID of rollershutters
local danalockID = {} -- ID Danalock

local countID = 500

-- NO MORE CHANGE

function sendPush(text)
 if (phoneID[1] ~= nil) then
  for k=1, countID do
     if phoneID[k] ~= nil then
       fibaro:call(phoneID[k],'sendPush', text, 'smoke')
     end
  end
 end
end

function onoffSirene(status)
 if (sireneID[1] ~= nil) then 
  if (status == 'true') then
   fibaro:debug('Switch siren(s) on')
   for a=1, countID do
     if sireneID[a] ~= nil then
       fibaro:call(sireneID[a],'turnOn')
     end
   end
  else
   if (sireneID[1] ~= nil) then  
    fibaro:debug('Switch siren(s) off')
    for a=1, countID do
      if sireneID[a] ~= nil then
        fibaro:call(sireneID[a],'turnOff')
      end
    end
   end
  end
 end
end

function emergencyLight(status)
 if (lightID[1] ~= nil) then 
  if (status == 'true') then
   fibaro:debug('Switch emergency lighting on')
   for l=1, countID do
     if lightID[l] ~= nil then
       fibaro:call(lightID[l],'turnOn')
     end
   end
  else
   if (lightID[1] ~= nil) then 
    fibaro:debug('Switch emergency lighting off')
    for l=1, countID do
      if lightID[l] ~= nil then
        fibaro:call(lightID[l],'turnOff')
      end
    end 
   end
  end
 end
end

function emergencyRGBW(status)
 if (rgbwID[1] ~= nil) then 
  if (status == 'true') then
   if (mode == 'color') then 
    fibaro:debug('Switch rgbw emergency lighting on - Setting color')
    local RGBWTable = {}
    local i = 1
    for value in string.gmatch(color,"(%d+)") do
     RGBWTable[i] = value
     i = i + 1
    end
    for o=1, countID do
      if rgbwID[o] ~= nil then
        fibaro:call(rgbwID[o], "setColor", RGBWTable[1], RGBWTable[2], RGBWTable[3], RGBWTable[4])
      end
    end
   elseif (mode == 'programm') then
    fibaro:debug('Switch rgbw emergency lighting on - Start programm')
    for o=1, countID do
     if rgbwID[o] ~= nil then
       fibaro:call(rgbwID[o], 'startProgram', programm)
     end
    end
   end 
  else
   if (rgbwID[1] ~= nil) then 
    fibaro:debug('Switch rgbw emergency lighting off')
    for o=1, countID do
      if rgbwID[o] ~= nil then
        fibaro:call(rgbwID[o], "setColor", 255,0,0,0)
      end
    end 
   end
  end
 end
end

function openEscapeRoute()
  if (rollershutterID[1] ~= nil) then
    fibaro:debug('Shutters are opened.')
    for r=1, countID do
     if rollershutterID[r] ~= nil then
       fibaro:call(rollershutterID[r],'open')
     end
    end
  if (danalockID[1] ~= nil) then
    fibaro:debug('Doorlocks are opened.')
    for d=1, countID do
     if danalockID[d] ~= nil then
       fibaro:call(danalockID[d],'unsecure')
     end
    end
  end
 end
end

function globalVar(var,val)
  local http = net.HTTPClient()
  http:request("http://127.0.0.1:11111/api/globalVariables", {
    options = {
    method = 'POST',
    headers = {},
    data = '{"name":"'..var..'","value":"'..val..'"}',
    timeout = 10000
  },
  success = function(response)
            local result = response.data;
            if response.status == 200 or response.status == 201 then
              fibaro:debug('Status: ' ..response.status.. ' - Variable was created')
            else
              fibaro:debug('Error: ' ..response.status.. ' - Access denied')
            end
            end,
  error = function(err)
          fibaro:debug('[ERROR] ' .. err)
          end
  })
end

function checkSmoke()
 fibaro:debug('1 smoke detector reports securely. Check the other sensors.')
 local smoke_counter = 0 
 for s=1, countID do
    if smokeID[s] ~= nil then
      if tonumber(fibaro:getValue(smokeID[s], "value")) == 1 then
        smoke_counter = smoke_counter+1
      end
    end
 end
 if (smoke_counter == 0) then
   fibaro:debug('All smoke detectors are safe.')
   return true
 elseif (smoke_counter > 0) then
   fibaro:debug(smoke_counter..' Smoke detectors still not safe ...')
   return false
 end
end

fibaro:debug('Smoke detector scene v1.1RC starts.')

local var = 'smoke_alarm'

local trigger = fibaro:getSourceTrigger()

if (trigger['type']=='property') then
  local smokeID = tonumber(trigger['deviceID'])
  local smoke = tonumber(fibaro:getValue(smokeID, "value"))
  local room = fibaro:getRoomNameByDeviceID(smokeID)
  if (fibaro:getGlobal(var) ~= nil) then
    fibaro:debug('Required variable ' ..var.. ' detected.')
  else
    fibaro:debug('Required variable ' ..var.. ' NOT detected. Is created.')
    globalVar(var, 'false')
  end
  if (smoke == 1 and fibaro:getGlobal(var) == 'false') then
  	fibaro:debug('Smoke in room: ' .. room .. ' detected.')
    fibaro:setGlobal(var, 'true')
    onoffSirene(fibaro:getGlobal(var))
    emergencyLight(fibaro:getGlobal(var))
    openEscapeRoute()
    emergencyRGBW(fibaro:getGlobal(var))
    sendPush('ATTENTION! Smoke in room: ' .. room .. ' detected!')
  elseif (smoke == 0 and fibaro:getGlobal(var) == 'true') then
    if checkSmoke() then
      fibaro:debug('Switch off smoke alarm')
      fibaro:setGlobal(var, 'false')
      onoffSirene(fibaro:getGlobal(var))
      emergencyLight(fibaro:getGlobal(var))
      emergencyRGBW(fibaro:getGlobal(var))
      sendPush('All smoke detectors reports safe.')
    end
  elseif (smoke == 1 and fibaro:getGlobal(var) == 'true') then
    fibaro:debug('Aother smoke detector in '..room..' reports smoke. Already triggered alarm.')
    sendPush('Weiterer Rauchmelder - '..room..' - ausgelöst!')
  elseif (fibaro:getGlobal(var) == 'NaN') then
    fibaro:debug('ATTENTION: Value of the variable is not correct. Start the scene manually')
  else
    fibaro:debug('Scene was triggered by smoke detectors. There is no smoke.')
  end
else
  fibaro:debug('Scene was started manually')
  if (fibaro:getGlobal(var) ~= nil) then
    fibaro:debug('Required variable ' ..var.. ' detected.')
     if (fibaro:getGlobal(var) == 'NaN') then
       fibaro:debug('Content: ' ..fibaro:getGlobal(var).. ' detected. Will be corrected.')
       fibaro:setGlobal(var, 'false')
     else
       fibaro:debug('Content: ' ..fibaro:getGlobal(var).. ' detected. Is correct.')
     end
     fibaro:debug('Sending a Test-Push-Message.')
     sendPush('Push message works. IDs of phones correctly.')
  else
    fibaro:debug('Required variable ' ..var.. ' NOT detected. Is created.')
    globalVar(var, 'false')
    sendPush('Push message works. IDs of phones correctly.')
    fibaro:debug('Sending a Test-Push-Message.')
  end
end